define([
    'Layout',
    'modules/landing-page/landing-page-view',
], function(Layout, LandingPageView) {
    'use strict';

    describe('Landing Page - Not Authenticated', function() {
        var view;
        var $view;
        var layout = new Layout();

        layout.render();

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            spyOn(LandingPageView.prototype, 'showLogin');
            view = new LandingPageView();

            layout.showChildView('content', view);
            $view = view.$el;
        });

        // afterEach(function() {
        //  layout.getRegion('content').empty();
        // });

        it('has a welcome message', function () {
            expect($view.find('#welcome').find('.ui-hidden-accessible')
                .text())
                .toEqual('Welcome to VA Appointments App');
        });

        // TODO: pull out authentication utility from Global utility
        it('has a login button', function() {

            var loginBtn = $view.find('#login-btn');
            expect(loginBtn.text()).toEqual('Login');

            loginBtn.trigger('click');
            expect(view.showLogin).toHaveBeenCalled();
        });
    });
});
